/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.mixin;

import com.supermartijn642.formations.Formations;
import com.supermartijn642.formations.structure.BlockInstance;
import com.supermartijn642.formations.structure.FormationsStructureProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_4538;
import net.minecraft.class_5425;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={class_3499.class})
public class StructureTemplateMixin {
    @ModifyVariable(method={"processBlockInfos"}, at=@At(value="HEAD"), ordinal=0)
    private static List<class_3499.class_3501> processBlockInfos(List<class_3499.class_3501> blocks, class_5425 level, class_2338 piecePosition, class_2338 structurePosition, class_3492 placeSettings) {
        List<FormationsStructureProcessor> processors = placeSettings.method_16182().stream().filter(FormationsStructureProcessor.class::isInstance).map(FormationsStructureProcessor.class::cast).toList();
        if (processors.isEmpty()) {
            return blocks;
        }
        Map<class_2338, BlockInstance> blocksByPosition = blocks.stream().collect(Collectors.toUnmodifiableMap(block -> block.comp_1341().method_10081((class_2382)piecePosition), block -> new BlockInstance(block.comp_1342(), block.comp_1343())));
        ArrayList<class_3499.class_3501> newBlocks = new ArrayList<class_3499.class_3501>(blocks.size());
        for (Map.Entry<class_2338, BlockInstance> entry : blocksByPosition.entrySet()) {
            class_2338 pos = entry.getKey();
            BlockInstance block2 = entry.getValue();
            for (FormationsStructureProcessor processor : processors) {
                try {
                    BlockInstance newBlock = processor.processBlock(block2, pos, (class_4538)level, piecePosition, structurePosition, placeSettings, blocksByPosition);
                    if (newBlock == null) {
                        throw new NullPointerException("Processor returned null!");
                    }
                    block2 = newBlock;
                }
                catch (Exception e) {
                    Formations.LOGGER.error("Encountered an exception whilst processing block '" + String.valueOf(block2) + "' with processor of class '" + String.valueOf(processor.getClass()) + "'!", (Throwable)e);
                }
            }
            if (block2.state() == null) continue;
            newBlocks.add(new class_3499.class_3501(pos.method_10059((class_2382)piecePosition), block2.state(), block2.nbt()));
        }
        return newBlocks;
    }
}

